-- FirstStage generated output file
require('scripts/style.lua');

CustomCreator('Slider');
CustomCreator('ChooseGameType');

SetDefaultStyle( DefaultStyle );

GameNameFont = {
	defaultFont,
	22,
	BlackColor
};

GameDetailsFont = {
	defaultFont,
	14,
	BlackColor
};


TitleFont = {
	proportionalFont,
	40,
	Color(0, 0, 20,255)
};

HeaderFont = {
	proportionalFont,
	20,
	Color(0, 0, 20,255)
};

HelpFont = {
	proportionalFont,
	16,
	Color(0, 0, 20,255)
};


GreyedFont ={
  standardFont, 
  16,
  Color(145,144,90,255)
};

RestaurantFont ={
  standardFont, 
  16,
  BlackColor
};

local d=LargeDialog			 
local yStart=0
local ySpace=68.5

gBuildingSlotHeight =67

ScrollArrowGraphics = { 
	"multi/scrollbar_arrow_a", 
	"multi/scrollbar_arrow_b", 
	"multi/scrollbar_arrow_b" 
}

BuildingButton=
{
  	parent=RadioButton,
  	graphics={ "common/empty", 'multi/hilite', 'multi/hilite_over' };
  	scale = 1.0,
  	type= kRadio,
}

kSlotX = 0;
kHeaderOffset = 10;

function Slot( num, offset )
	local startgroup = false;
	return Group {
		SetStyle(BuildingButton),
		Button
		{
            x = kSlotX,
            y = offset,
			h = gBuildingSlotHeight,
			tw = 0,
			name="button_"..num,
			
			SelectLayer(kAllLayers),
			Text
			{
				font = GameNameFont,
				x = 10, y = 15,
				w = kMax, h = kMax,
				flags=kHAlignLeft+kVAlignTop,
				label = 'gamename_'..num,
				name = 'gamename_'..num,
			},
			
			Text
			{
				font = GameDetailsFont,
				x = 10, y = 40,
				w = kMax - 10, h = kMax,
				flags=kHAlignLeft+kVAlignTop,
				label = 'mpdifficulty_0',
				name = 'difficulty_'..num,
			};
			
			Text
			{
				font = GameDetailsFont,
				x = 10, y = 15,
				w = kMax - 10, h = kMax,
				flags=kHAlignRight+kVAlignTop,
				label = 'gamemode_'..num,
				name = 'gamemode_'..num,
			},
			
			Text
			{
				font = GameDetailsFont,
				x = 10, y = 35,
				w = kMax - 10, h = kMax,
				flags=kHAlignRight+kVAlignTop,
				label = 'tablemode_'..num,
				name = 'tablemode_'..num,
			},

		},
	}
end

MakeDialog
{
	Bitmap
	{
		name = 'mpchoosegametypewin',
		image = 'multi/mp_game_dialog',
		x = kCenter,
		y = kCenter,
	
		
		SetStyle(DefaultStyle);
		
		Text
		{
			font=TitleFont,
			label = 'mppickgametype',
			name = 'pickgametype',
			flags = kHAlignCenter+kVAlignTop,
			x = kCenter,
			y = 20,
			w = kMax,
			h = 100,
		},
		
		Text
		{
			font=HeaderFont,
			label = 'mppickgametype',
			name = 'mppickgametypeinfo',
			flags = kHAlignCenter+kVAlignTop,
			x = 20,
			y = 60,
			w = kMax-20,
			h = 100,
		},
		
		Text
		{
			font=HelpFont,
			label = 'mppickgametypehelp',
			name = 'mppickgametypehelp',
			flags = kHAlignLeft+kVAlignTop,
			x = 160,
			y = 400,
			w = kMax-30,
			h = 100,
		},

		Bitmap
		{
			image = "multi/scroll_window",
			x = 30,
			y = 105,

			ChooseGameType
			{
				x=0,y=0,w=kMax,h=kMax,
				name="choosegamescroll",
				hslider=false, 
				showarrows=true,
				arrowgraphics=ScrollArrowGraphics,
				sliderimage="multi/scrollbar_knob",
				sliderrollimage="multi/scrollbar_knobover",
				railbot="multi/scrollbar_bot",
				railtop="multi/scrollbar_top",
				railmid="multi/scrollbar_mid",
				

				Window
				{
					x=0,y=1,
					BeginGroup(),
					Slot(1,yStart+ySpace*0),
					Slot(2,yStart+ySpace*1),
					Slot(3,yStart+ySpace*2),
					Slot(4,yStart+ySpace*3),
				};
			};
		};
		SetStyle( MainMenuButtonStyle7 ),
		
		Button
		{
			label = 'help',
			name = 'help',
			x = 50,
			y = 395,
			command=
				function()
					DoModal("scripts/multiplayer/gametypehelp.lua");
				end
			
		},
		
		Button
		{
			label = 'back',
			name = 'back',
			x = 50,
			y = 440,
			command=
				function()
					PopModal( 'scripts/multiplayer/choosegametype.lua' );
					ModalReturn( DoModal('scripts/multiplayer/choosegamerestaurant.lua' ) );
				end
		},
		
		Bitmap
		{
			image="buttons/menu_button7d",
			x = 270,
			y = 440,
			name = 'okdisabled',
			Text
			{
				font = GreyedFont,
				x = 0,
				y = 0,
				w=kMax, h=kMax - 5,
				flags = kHAlignCenter + kVAlignCenter,
				label="next",
			};
		}; 

		Button
		{
			label = 'next',
			name = 'ok',
			x = 270,
			y = 440,
			command=
				function()
					if (MultiPlayerGame(false)) then
						SetGameType( GetGameTypeSelected() );
					end
					ModalReturn ( GetGameTypeSelected() );
					PopModal( 'scripts/multiplayer/choosegametype.lua' );
				end
		},
	};
} -- MakeDialog

EnableWindow("ok", false);